# -*- coding: utf-8 -*-
"""
Created on Sun Jan  8 18:05:09 2012

@author: Sebastian Brueckner <sebastianb@ags.tu-bs.de>

Based on:
    http://www.heise.de/ct/projekte/machmit/asteroids/attachment/wiki/Tools/vda.pl
    http://www.philpem.me.uk/elec/vecgen.pdf
    
I am a Python beginner, so if you have any advice on how to do this properly I am keen
to hear it!

"""

import numpy as np

vctr_s = {
    0 : 512,
    1 : 256,
    2 : 128,
    3 : 64,
    4 : 32,
    5 : 16,
    6 : 8,
    7 : 4,
    8 : 2,
    9 : 1,
}

svec_s = {
    0 : 128,
    1 : 64,
    2 : 32,
    3 : 16
}

def parse(filename):
    global vctr_s
    
    with open(filename, 'r') as f:
        vram = f.read()
        
    vram = np.fromstring(vram, dtype=np.uint16)
        
    op = 0
    
    vec = []
    g_vec = []
    vec_end = 0

    while op < len(vram):
        
        step = 1        
        
        instr1 = vram[op] 
        instr2 = vram[op+1]
        
        instr = instr1 >> 12
                
        txt = ""
        
        
        if instr <= 9:
            y = instr1 & 0x03FF
            if instr1 & 0x0400:
                y = -y
            x = instr2 & 0x03FF
            if instr2 & 0x0400:
                x = -x
            z = (instr2 & 0xF000) >> 12
            s = vctr_s[(instr1&0xF000)>>12]
            txt = "VCTR (%i, %i, %i)/%i"%(x, y, z, s)
            if len(vec)==0: 
                vec.append(op)
            vec.append((x/s, y/s, z))
            vec_end = 0
            step = 2
        elif instr == 0xA:
            txt = "LABS"
            vec_end = 1
            step = 2
        elif instr == 0xB:
            txt = "HALT"
            vec_end = 1
        elif instr == 0xC:
            addr = instr1 & 0x03FF
            txt = "JSRL %04X"%addr
            vec_end = 1
        elif instr == 0xD:
            addr = instr1 & 0x03FF
            txt = "RTSL %04X"%addr
            vec_end = 1
        elif instr == 0xE:
            addr = instr1 & 0x03FF
            txt = "JMPL %04X"%addr
            vec_end = 1
        elif instr == 0xF:
            y = instr1 & 0x0300
            if instr1 & 0x0400:
                y = -y
            x = (instr1 & 0x0003)<<8
            if instr1 & 0x0004:
                x = -x
            z = (instr1 & 0x00F0) >> 4
            s = ((instr1 & 0x0800) >> 11) | ((instr1 & 0x0008) >> 2)
            s = svec_s[s]
            txt = "SVEC (%i, %i, %i)/%i"%(x, y, z, s)
            if len(vec)==0: 
                vec.append(op+2048)
            vec.append((x/s, y/s, z))
            vec_end = 0
            
        line = "%04X %04X "%(op+2048, instr1)
        if step == 2:
            line += "%04X"%instr2
        else:
            line += "    "
        line += " " + txt
        print line
        
        if vec and vec_end:
            if len(vec) > 2:
                g_vec.append(vec)
            vec = []
        
            
        op += step
        
    for v in g_vec:
        print v, ","



    return g_vec

if __name__ == '__main__':
    parse('035127-02.np3')