# -*- coding: utf-8 -*-

import sys
from PyQt4 import QtGui, QtCore, Qt
import numpy as np
import parser 

class VectorDisplay(QtGui.QWidget):
    
    def __init__(self):
        super(VectorDisplay, self).__init__()
        
        self.setFixedSize(QtCore.QSize(255, 255))
        
        self.position = QtCore.QPoint(127, 127)
        
        self.vecList = [(0, 0, 0),]
        
    def sizeHint(self):
        return QtCore.QSize(255, 255)
        
    def clear(self):
        
        self.vecList = [(0, 0, 0),]

    def vector(self, x, y, z, scale=1):
        
        self.vecList.append((x*scale, y*scale, z))
        
    def veclist(self, l, scale=1):
        
        for v in l:
            x = int(v[0]*scale)
            y = int(v[1]*scale)
            print x, y, v[2]
            self.vecList.append((x, y, v[2]))

    def zero(self):
        
        self.vecList.append((0,0,0))
    
    def paintEvent(self, e):
        
        print "paintEvent"
      
        qp = QtGui.QPainter()
        qp.begin(self)
        self.drawWidget(qp)
        qp.end()
      
    def drawWidget(self, qp):
      
        font = QtGui.QFont('Serif', 7, QtGui.QFont.Light)
        qp.setFont(font)
        

        size = self.size()
        w = size.width()
        h = size.height()
        
        px = w/2
        py = h/2
        
        qp.setBrush(QtGui.QColor(0, 0, 0))
        qp.fillRect(QtCore.QRect(QtCore.QPoint(0,0), size), QtGui.QColor(0, 0, 0))

             
        qp.setPen(QtGui.QColor(0, 0, 200))
        qp.drawRect(1, 1, 255, 255)
        #qp.drawLine(0, 0, 50, 50)

        for v in self.vecList:
            if v[0]==0 and v[1]==0 and v[2]==0:
                px = w/2
                py = h/2
            else:
                b = v[2] * 16                
                #if b==0:
                #    b = 20
                qp.setPen(QtGui.QColor(b, b, b))
                line = QtCore.QLine(px, py, px+v[0], py-v[1])
                
                
                tmp = qp.compositionMode()
                qp.setCompositionMode(QtGui.QPainter.CompositionMode_Plus)

                #print line
                if v[0]==0 and v[1]==0:
                    print "point:", px-w/2, py-h/2, b                    
                    qp.drawPoint(px, py)
                else:                
                    qp.drawLine(line)
                    
                qp.setCompositionMode(tmp)

                px += v[0]
                py -= v[1]

class MainWnd(QtGui.QWidget):
    
    def __init__(self):
        super(MainWnd, self).__init__()
        
        self.g_vec = []        
        
        self.initUI()
        
    def initUI(self):      
        global g_vec
        
        
        self.btnLoad = QtGui.QPushButton("Load vector ROM...", self)
        self.btnLoad.clicked.connect(self.loadROM)
                
        self.spinNum = QtGui.QSpinBox(self)
        self.spinNum.setValue(0)
        self.spinNum.setMaximum(100)
        self.spinNum.setSingleStep(1)
        self.spinNum.valueChanged.connect(self.showVec)
        
        self.lblNum = QtGui.QLabel()
        self.lblAddr = QtGui.QLabel()
        
        self.display = VectorDisplay()

        vbox = QtGui.QVBoxLayout()
        vbox.addWidget(self.btnLoad, 0)
        vbox.addWidget(self.lblNum, 0)
        vbox.addWidget(self.spinNum, 0)
        vbox.addWidget(self.lblAddr, 0)
        vbox.addStretch(1)
        
        hbox = QtGui.QHBoxLayout()
        hbox.addLayout(vbox, 0)
        hbox.addWidget(self.display, 1)

        self.setLayout(hbox)    
        
        self.setGeometry(300, 300, 300, 150)
        self.setWindowTitle('Vector Preview')
        self.show()
                
    def loadROM(self):
        
        filename = QtGui.QFileDialog.getOpenFileName(self, 'Open file', '.')        
        
        self.g_vec = parser.parse(filename)
        
        self.lblNum.setText("%i objects found"%(len(self.g_vec)))
        
        self.spinNum.setMaximum(len(self.g_vec)-1)

    def showVec(self):
        
        num = self.spinNum.value()
        
        if len(self.g_vec) == 0: return
        
        self.lblAddr.setText("word addr: %04X"%(self.g_vec[num][0]))
        
        self.display.clear()

        self.display.zero()
        self.display.veclist(self.g_vec[num][1:], 1)
     
        self.display.repaint()


def main():
    
    app = QtGui.QApplication(sys.argv)
    ex = MainWnd()
    sys.exit(app.exec_())


if __name__ == '__main__':
    main()
