/*----------------------------------------------------------------------*/
/* FAT file system sample project for FatFs            (C)ChaN, 2009    */
/*----------------------------------------------------------------------*/


#include <avr/io.h>
#include <avr/pgmspace.h>
#include <avr/interrupt.h>
#include <util/delay.h>
#include <string.h>
#include "uart.h"
#include "xitoa.h"
#include "ff.h"
#include "diskio.h"
#include "rtc.h"
#include "config.h"

FATFS Fatfs[1];				/* File system object for each logical drive */
DIR g_dirs;
FILINFO Finfo;

#define BUFSIZE 512
BYTE Buff1[BUFSIZE];			/* Working buffer */
BYTE Buff2[BUFSIZE];			/* Working buffer */

volatile BYTE buf_curr;

volatile BYTE g_done = 0;

volatile WORD Timer;		/* 100Hz increment timer */


/*---------------------------------------------------------*/
/* 100Hz timer interrupt generated by OC2                  */
/*---------------------------------------------------------*/

ISR(TIMER2_COMP_vect)
{
	LEDD_PORT ^= (1<<LEDD_BIT);

	Timer++;			/* Performance counter for this module */
	disk_timerproc();	/* Drive timer procedure of low level disk I/O module */
}



/*---------------------------------------------------------*/
/* User Provided Timer Function for FatFs module           */
/*---------------------------------------------------------*/
/* This is a real time clock service to be called from     */
/* FatFs module. Any valid time must be returned even if   */
/* the system does not support a real time clock.          */
/* This is not required in read-only configuration.        */


static
void IoInit ()
{
	LEDA_DDR |= (1<<LEDA_BIT);
	LEDB_DDR |= (1<<LEDB_BIT);
	LEDC_DDR |= (1<<LEDC_BIT);
	LEDD_DDR |= (1<<LEDD_BIT);
	LEDE_DDR |= (1<<LEDE_BIT);

	SWE_DDR  &= ~(1<<SWE_BIT);
	SWE_PORT |=  (1<<SWE_BIT);

	SPK_DDR  |=  (1<<SPK_BIT);

	BTN_DDR  &= ~BTN_MASK;
	BTN_PORT |= BTN_MASK;

	uart_init();		// Initialize UART driver

	TCCR1A = (1<<COM1A1)|(1<<WGM10); // fast PWM, prescaler = 1
	TCCR1B = (1<<WGM12)|(1<<CS10);

	OCR2 = 70;		// Timer2: 100Hz interval (OC2)
	TCCR2 = (1<<WGM21)|(1<<CS22)|(1<<CS21)|(1<<CS20); // CTC, prescaler = 1024
	TIMSK = 0b10000000;	// Enable TC2.oc, interrupt

	TCCR0 |= (1<<WGM01)|(1<<CS01);  // prescaler = 8
    TIMSK |= (1<<OCIE0);
    
	//OCR0 = 125;                     // 8kHz interrupt freq. @ 8MHz
	OCR0 = 230;                     // 8kHz interrupt freq. @ 14.7456MHz

	sei();
}


// 8 kHz
ISR (TIMER0_COMP_vect)
{
	static uint16_t pos;

	// TODO: can't detect buffer underrun!!!!!!!!
	//if(g_done) { LED_PORT |= LEDA_BIT; return; }
	//
	LEDA_PORT ^= (1<<LEDA_BIT);


	if(buf_curr == 1)
	{
    	OCR1A = Buff1[pos++]; 

		if(pos >= BUFSIZE)
		{
			pos = 0;
			buf_curr = 2;
			g_done = 1;
		}
	}
	else if(buf_curr == 2)
	{
    	OCR1A = Buff2[pos++]; 

		if(pos >= BUFSIZE)
		{
			pos = 0;
			buf_curr = 1;
			g_done = 1;
		}
	}

}

int track_next(FIL *file);
int track_init(FIL *file)
{
	FRESULT res;

	res = f_opendir(&g_dirs, "");
	if(res != FR_OK) { xprintf(PSTR("f_opendir = %d\n"), res); return -1; }

	return track_next(file);
}

int track_next(FIL *file)
{
	FRESULT res;
	char *fn;

	while(1) {
		res = f_readdir(&g_dirs, &Finfo);
		if(res != FR_OK) { xprintf(PSTR("f_readdir = %d\n"), res); return -2; }
		if(!Finfo.fname[0]) { xprintf(PSTR("filename empty\n")); return -3; }
		if (_FS_RPATH && Finfo.fname[0] == '.') continue;
		fn = Finfo.fname;
		xprintf(PSTR("filename: %s\n"), fn);
		if(strstr(Finfo.fname, ".RAW")) break;
	}

	xprintf(PSTR("found next file: %s\n"), fn);
	res = f_open(file, fn, 1);
	xprintf(PSTR("f_open = %d\n"), res);
	return res;
}


/*-----------------------------------------------------------------------*/
/* Main                                                                  */


int main (void)
{
	BYTE res;

	UINT cnt;
	FIL file1;		/* File object */


	IoInit();


	buf_curr = 0;


	/* Join xitoa module to uart module */
	xfunc_out = (void (*)(char))uart_put;

	xputs(PSTR("FatFs R0.07d test monitor for AVR\n"));

	res = disk_initialize(0);
	xprintf(PSTR("disk_initialize = %d\n"), res);

	if(res)
	{
		xputs(PSTR("Initializing SD card failed. Dying.\n"));
		while(1);
	}

	xprintf(PSTR("f_mount = %d\n"), (WORD)f_mount((BYTE)0, &Fatfs[0]));

		//////////////////////////////////////////////////////////////
		// Directory Listing
/*
				res = f_opendir(&dir, "");
				if (res) { put_rc(res); while(1); }
				p1 = s1 = s2 = 0;

				for(;;) {
					res = f_readdir(&dir, &Finfo);
					if ((res != FR_OK) || !Finfo.fname[0]) break;
					if (Finfo.fattrib & AM_DIR) {
						s2++;
					} else {
						s1++; p1 += Finfo.fsize;
					}
					xprintf(PSTR("%c%c%c%c%c %u/%02u/%02u %02u:%02u %9lu  %s"), 
								(Finfo.fattrib & AM_DIR) ? 'D' : '-',
								(Finfo.fattrib & AM_RDO) ? 'R' : '-',
								(Finfo.fattrib & AM_HID) ? 'H' : '-',
								(Finfo.fattrib & AM_SYS) ? 'S' : '-',
								(Finfo.fattrib & AM_ARC) ? 'A' : '-',
								(Finfo.fdate >> 9) + 1980, (Finfo.fdate >> 5) & 15, Finfo.fdate & 31,
								(Finfo.ftime >> 11), (Finfo.ftime >> 5) & 63,
								Finfo.fsize, &(Finfo.fname[0]));

					xputc('\n');

				}
				xprintf(PSTR("%4u File(s),%10lu bytes total\n%4u Dir(s)"), s1, p1, s2);
				xputc('\n');
				//if (f_getfree(ptr, &p1, &fs) == FR_OK)
				//	xprintf(PSTR(", %10luK bytes free\n"), p1 * fs->csize / 2);
				
*/				
				//////////////////////////////////////////////////////////////////		

		//xprintf(PSTR("f_open = %d\n"), f_open(&file1, "test.raw", 1));


	LEDB_PORT |= (1<<LEDB_BIT);

	track_init(&file1);

		while(1)
		{
				cnt = BUFSIZE;
				res = f_read(&file1, Buff1, cnt, &cnt);

				cnt = BUFSIZE;
				res = f_read(&file1, Buff2, cnt, &cnt);

				buf_curr = 1;
				g_done = 0;

				while (1) {

					if(g_done)
					{
						if(buf_curr == 2)
						{
							cnt = BUFSIZE;
							res = f_read(&file1, Buff1, cnt, &cnt);
							if (res != FR_OK) { xprintf(PSTR("f_read: %d\n"), res); break; }
							if (!cnt) break;
							//buf_curr = 1;
						}
						else if(buf_curr == 1)
						{
							cnt = BUFSIZE;
							res = f_read(&file1, Buff2, cnt, &cnt);
							if (res != FR_OK) { xprintf(PSTR("f_read: %d\n"), res); break; }
							if (!cnt) break;
							//buf_curr = 2;
						}

						g_done = 0;

						LEDA_PORT ^= (1<<LEDA_BIT);
					}

					
					
					
					if(BUTTON_PRESSED()) break;


				}

		track_next(&file1);
		_delay_ms(300);

	}
				
		LEDA_PORT |= (1<<LEDA_BIT);
		LEDB_PORT |= (1<<LEDB_BIT);


	while(1);

}

