#if !defined(LCD_H_)
#define LCD_H_

#define SPI_SCK  			PB7
#define SPI_MISO 			PB6
#define SPI_MOSI 			PB5
#define SPI_CS   			PB4

#define LCD_CMD_SWRESET		0x01
#define LCD_CMD_BSTRON		0x03
#define LCD_CMD_SLEEPIN		0x10
#define LCD_CMD_SLEEPOUT	0x11
#define LCD_CMD_NORMAL	 	0x13
#define LCD_CMD_INVOFF		0x20
#define LCD_CMD_INVON		0x21
#define LCD_CMD_SETCON		0x25
#define LCD_CMD_DISPON		0x29
#define LCD_CMD_CASET		0x2A
#define LCD_CMD_PASET		0x2B
#define LCD_CMD_RAMWR		0x2C
#define LCD_CMD_RGBSET		0x2D
#define LCD_CMD_MADCTL		0x36
#define LCD_CMD_COLMOD		0x3A

#define MADCTL_HORIZ		0x08
#define MADCTL_VERT			0x28

void spi_init(void);
void lcd_init(void);
void lcd_wrcmd(uint8_t cmd);
void lcd_wrdata(uint8_t data);
void lcd_window(uint8_t xp, uint8_t yp, uint8_t xe, uint8_t ye);
void lcd_clrscr(void);

#endif // LCD_H_
