#include <avr/io.h>
#include <util/delay.h>
#include <inttypes.h>

#include "lcd.h"

void spi_init()
{
	uint8_t tmp;

	// PB3 : backlight enable
	// PB4 : chip select
	// PB5 : MOSI
	// PB6 : MISO
	// PB7 : SCK
	DDRB |= (1<<PB3)|(1<<PB4)|(1<<PB5)|(1<<PB7);
	PORTB |= (1<<PB3); // turn on backlight
	
	SPCR = (1<<MSTR) | (1<<SPE);
	SPSR |= (SPI2X);

	tmp = SPDR; // clear flags
}


void lcd_init()
{
	spi_init();

	lcd_wrcmd(LCD_CMD_SWRESET);
	_delay_ms(1);

	lcd_wrcmd(LCD_CMD_SLEEPOUT);
	lcd_wrcmd(LCD_CMD_DISPON);
	lcd_wrcmd(LCD_CMD_BSTRON);
	_delay_ms(1);

	lcd_wrcmd(LCD_CMD_MADCTL);
	lcd_wrdata(MADCTL_HORIZ); // BGR format, no mirroring

	lcd_wrcmd(LCD_CMD_COLMOD);
	lcd_wrdata(0x02); // 256 colors
}

void lcd_wrcmd(uint8_t cmd)
{
	PORTB &= ~(1<<SPI_CS);
	SPCR &= ~(1<<SPE);

	PORTB &= ~(1<<SPI_MOSI);
	PORTB |= (1<<SPI_SCK);
	PORTB &= ~(1<<SPI_SCK);

	SPCR |= (1<<SPE);
	SPDR = cmd;
	while( ! (SPSR & (1<<SPIF)) );

	PORTB |= (1<<SPI_CS);
}

void lcd_wrdata(uint8_t data)
{
	PORTB &= ~(1<<SPI_CS);
	SPCR &= ~(1<<SPE);

	PORTB |= (1<<SPI_MOSI);
	PORTB |= (1<<SPI_SCK);
	PORTB &= ~(1<<SPI_SCK);

	SPCR |= (1<<SPE);
	SPDR = data;
	while( ! (SPSR & (1<<SPIF)) );

	PORTB |= (1<<SPI_CS);
}

void lcd_window(uint8_t xp, uint8_t yp, uint8_t xe, uint8_t ye)
{
	lcd_wrcmd(LCD_CMD_CASET);
	lcd_wrdata(xp);
	lcd_wrdata(xe);

	lcd_wrcmd(LCD_CMD_PASET);
	lcd_wrdata(yp);
	lcd_wrdata(ye);

	lcd_wrcmd(LCD_CMD_RAMWR);
}

void lcd_clrscr()
{
	uint16_t i;

	lcd_window(0, 0, 130, 130);

	for(i=0 ; i<=(131*131) ; i++)
		lcd_wrdata(0xFF);
}

