#if !defined(ACCEL_H_)
#define ACCEL_H_

#define MMA_ADDR (0x1D<<1)

// MMA7455L Register Adresses
#define MMA_XOUTL  0x00
#define MMA_XOUTH  0x01
#define MMA_YOUTL  0x02
#define MMA_YOUTH  0x03
#define MMA_ZOUTL  0x04
#define MMA_ZOUTH  0x05
#define MMA_XOUT8  0x06
#define MMA_YOUT8  0x07
#define MMA_ZOUT8  0x08
#define MMA_STATUS 0x09
#define MMA_DETSRC 0x0A
#define MMA_TOUT   0x0B
#define MMA_I2CAD  0x0D
#define MMA_USRINF 0x0E
#define MMA_WHOAMI 0x0F
#define MMA_XOFFL  0x10
#define MMA_XOFFH  0x11
#define MMA_YOFFL  0x12
#define MMA_YOFFH  0x13
#define MMA_ZOFFL  0x14
#define MMA_ZOFFH  0x15
#define MMA_MCTL   0x16
#define MMA_INTRST 0x17
#define MMA_CTL1   0x18
#define MMA_CTL2   0x19
#define MMA_LDTH   0x1A
#define MMA_PDTH   0x1B
#define MMA_PW     0x1C
#define MMA_LT     0x1D
#define MMA_TW     0x1E

// STATUS register bit names
#define DRDY 0
#define DOVR 1
#define PERR 2

// Pin assignment
#define MMA_INT_DDR  DDRD
#define MMA_INT_PORT PORTD
#define MMA_INT_PIN  PIND
#define MMA_INT_BIT  PD3


extern int8_t g_accel_x;
extern int8_t g_accel_y;
extern int8_t g_accel_z;

void accel_init(void);
void accel_read(void);

#endif // ACCEL_H_
