#include <avr/io.h>
#include <util/delay.h>
#include <inttypes.h>

#include "i2cmaster.h"
#include "accel.h"
#include "xitoa.h"

// Global variables
int8_t g_accel_x;
int8_t g_accel_y;
int8_t g_accel_z;


uint8_t i2c_writebyte(uint8_t device, uint8_t addr, uint8_t data)
{
	if(i2c_start(device+I2C_WRITE)) return 1;
	if(i2c_write(addr)) return 1;
	if(i2c_write(data)) return 1;
	i2c_stop();

	return 0;
}

void accel_init()
{
	uint8_t ret;

	// MMA7455 DRDY pin
	MMA_INT_DDR  &= (1<<MMA_INT_BIT);
	MMA_INT_PORT &= (1<<MMA_INT_BIT);

	i2c_init();
	
	// enable measurement mode
	ret = i2c_start(MMA_ADDR+I2C_WRITE);
	if(ret)
		xputs(PSTR("MMA7455: no answer.\n"));
	else
		xputs(PSTR("MMA7455: comunication OK.\n"));
	i2c_write(MMA_MCTL); // register address
	i2c_write(0x05); // register value: 2g range, measurement mode, DRDY/INT1 output enabled
	i2c_stop();
}

void accel_read()
{
	int8_t mma_x, mma_y, mma_z;

	// poll INT1 pin level (data ready DRDY) waiting for measurement to finish
	// high == measurement done
	// need to clear interrupt flags after reading data
	// TODO: this can be done more efficiently using INT1 ISR
	while( !( MMA_INT_PIN & (1<<MMA_INT_BIT) ) );

	// read multiple consecutive registers w/ auto-increment
	i2c_start(MMA_ADDR+I2C_WRITE);
	i2c_write(MMA_XOUT8); // address of FIRST register
	i2c_rep_start(MMA_ADDR+I2C_READ);
	mma_x = i2c_readAck(); // MMA_XOUT8
	mma_y = i2c_readAck(); // MMA_YOUT8
	mma_z = i2c_readNak(); // MMA_ZOUT8
	i2c_stop();

	// clear interrupt flags
	i2c_writebyte(MMA_ADDR, MMA_INTRST, 0x03);
	i2c_writebyte(MMA_ADDR, MMA_INTRST, 0x00);

	g_accel_x = mma_x;
	g_accel_y = mma_y;
	g_accel_z = mma_z;
}
