#include <avr/io.h>
#include <avr/pgmspace.h>
#include <stdint.h>
#include "global.h"

const char splash[] PROGMEM = 
"                                                                                " // 0
" ##   ##   ####    ###                                                          " // 1
" ##   ##  ##  ##  ## ##        by                                               " // 2
" ##   ## ##      ##   ##         Jan Roesler           jan.roesler@tu-bs.de     " // 3
" ##   ## ##      #######         & Sebastian Br\x81" "ckner  se.brueckner@tu-bs.de    " // 4
" ##   ## ##  ### ##   ##                                                        " // 5
"  ## ##   ##  ## ##   ##       V0.000000002                                     " // 6
"   ###     ### # ##   ##                                                        " // 7
"                                                                                " // 8
"                  ######                            ##                    ###   " // 9
"                  ######                                                   ##   " // 10
"                  # ## #  #####  ## ###  ### ##    ###   ## ###   ####     ##   " // 11
"                    ##   ##   ##  ### ## #######    ##    ##  ##     ##    ##   " // 12
"                    ##   #######  ##     ## # ##    ##    ##  ##  #####    ##   " // 13
"                    ##   ##       ##     ## # ##    ##    ##  ## ##  ##    ##   " // 14
"                   ####   #####  ####    ## # ##   ####   ##  ##  ### ##  ####  "; // 15

const char sidescroll[] PROGMEM = 
" @@-@--:: "
"@@@@-@--::"
"@@----::: "
"@@        "
"@@@--     "
"@@@@-     "
"@@--@-    "
"@@        "
"@@@-@--:::"
"@@@@-@--: "
" @--@-::  "
"          "
"          "
"@@@----: :"
"@@@@----: "
"@@--@-::: "
"          "
"          "
"@@        "
"@@        "
"@@@-@--:  "
"@@@@----::"
"@@----::: "
"@@        "
"@@        "
"          "
"          "
"          "
"          "
"          "
" @@-@--:: "
"@@@@----::"
"@@--@-::  "
"@@  -@    "
"@@  @-    "
"@@@@----::"
"@@@-@--:: "
" @@@----::"
"          "
"          "
" @---   ::"
"@@@@--  ::"
"@@@-@-  : "
"@@  @@  ::"
"@@  -- -  "
"@@  ---:::"
"@@   -:-: "
"      -   "
"          "
"          "
" @---   ::"
"@@@@--  ::"
"@@@-@-  : "
"@@  @@  ::"
"@@  -- -  "
"@@  ---:::"
"@@   -:-: "
"      -   "
"          "
"          "
"@@@-@--: :"
"@@@@----: "
"@@----::::"
"@@  --   :"
"@@  :-  : "
"@@  -:  ::"
"@@      ::"
"@@      : "
"          "
"          "
"@@@-@--:: "
"@@@@-@--::"
"@@----::: "
"@@        "
"@@@--     "
"@@@@-     "
"@@--@-    "
"@@        "
"@@@-@--:::"
"@@@@-@--: "
" @--@-::  "
"          "
"          "
"@@@-@--: :"
"@@@@----::"
"@@- @-::: "
"@@  -@   :"
"@@  @-  : "
"@@@@----::"
"@@@-@--:::"
" @@@ ---: "
"          "
"          "
"@@@-@--  :"
"@@@@---:: "
"@@----:-::"
"       : :"
"        : "
"        ::"
"        : "
"        ::"
"          "
"          "
"@@@-@--: :"
"@@@@----: "
"@@----::::"
"@@  --   :"
"@@  :-  : "
"@@  -:  ::"
"@@      ::"
"@@      : "
"          "
"          "
"@@@-@--:: "
"@@@@----::"
"@@--@@::  "
"@@  --    "
"@@  -@:   "
"@@@@@---::"
"@@@-- -:: "
" @@@   -::"
"          "
"          "
"          "
"          "
"          "
"@@@-@--:: "
"@@@@-@--::"
"@@----::: "
"@@        "
"@@@--     "
"@@@@-     "
"@@--@-    "
"@@        "
"@@@-@--:::"
"@@@@-@--: "
" @--@-::  "
"          "
"          "
" @@-@--:: "
"@@@@----::"
"@@--@-::  "
"@@  -@    "
"@@  @-    "
"@@@@----::"
"@@@-@--:: "
" @@@----::"
"          "
"          "
" @----::  "
"@@@@@---::"
"@@@----:::"
"@@      : "
"@@       :"
"@@      ::"
"@@      : "
"@@      ::"
"          "
"          "
"@@@-@--:: "
"@@@@----::"
"@@--@-::  "
"    -@    "
"    @-    "
"@@@@----::"
"@@@-@--:: "
"@@@@----::"
"          "
"          "
"@@        "
"@@        "
"@@@-@--:  "
"@@@@----::"
"@@----::: "
"@@        "
"@@        "
"          "
"          "
"          "
"          "
"          "
"@@@-@--: :"
"@@@@-@--::"
"@@--@-::: "
"@@      ::"
"@@      : "
"@@@@----  "
"@@@-@--:::"
" @@@----: "
"          "
"          "
" @@-@--:: "
"@@@@----::"
"@@--@-::  "
"@@  -@    "
"@@  @-    "
"@@@@----::"
"@@@-@--:: "
" @@@----::"
"          "
"          "
" @---   ::"
"@@@@--  ::"
"@@@-@-  : "
"@@  @@  ::"
"@@  -- -  "
"@@  ---:::"
"@@   -:-: "
"      -   "
"          "
"          "
"          "
"          "
"          "
"@@@-@--  :"
"@@@@---:: "
"@@----:-::"
"       : :"
"        : "
"        ::"
"        : "
"        ::"
"          "
"          "
"@@@-@--: :"
"@@@@----: "
"@@----::::"
"@@  --   :"
"@@  :-  : "
"@@  -:  ::"
"@@      ::"
"@@      : "
"          "
"          "
"@@@-@--: :"
"@@@@----::"
"@@- @-::: "
"@@  -@   :"
"@@  @-  : "
"@@@@----::"
"@@@-@--:::"
" @@@ ---: "
"          "
"          "
"@@@-@--: :"
"@@@@----: "
"@@----::::"
"@@  --   :"
"@@  :-  : "
"@@  -:  ::"
"@@      ::"
"@@      : "
"          "
"          "
"@@@-@--: :"
"@@@@-@--::"
"@@--@-::: "
" @@-      "
"  -@-     "
"@@@-----  "
"@@@@@--:::"
"@@@-----: "
"          "
"          "
"          "
"          "
"          "
"@@@-@--: :"
"@@@@----: "
"@@----::::"
"@@  --   :"
"@@  :-  : "
"@@  -:  ::"
"@@      ::"
"@@      : "
"          "
"          "
"@@@----: :"
"@@@@----: "
"@@--@-::: "
"          "
"          "
"@@@-@--: :"
"@@@@-@--::"
"@@--@-::: "
" @@-      "
"  -@-     "
"@@@-----  "
"@@@@@--:::"
"@@@-----: "
"          "
"          "
"@@@-@--:  "
"@@@@----::"
"@@----::: "
"@@  --    "
"@@  :-    "
"@@  -:    "
"@@        "
"@@        "
"          "
"          "
" @@-@--:: "
"@@@@----::"
"@@--@-::  "
"@@  -@    "
"@@  @-    "
"@@@@----::"
"@@@-@--:: "
" @@@----::"
"          "
"          "
" @----::  "
"@@@@@---::"
"@@@----:::"
"@@      : "
"@@       :"
"@@      ::"
"@@      : "
"@@      ::"
"          "
"          "
"@@@-@--:: "
"@@@@----::"
"@@--@-::  "
"    -@    "
"    @-    "
"@@@@----::"
"@@@-@--:: "
"@@@@----::"
"          "
"          "
"          "
"          "
"          "
"@@@-@--:: "
"@@@@-@--::"
"@@----::: "
"@@        "
"@@@--     "
"@@@@-     "
"@@--@-    "
"@@        "
"@@@-@--:::"
"@@@@-@--: "
" @--@-::  "
"          "
"          "
"@@@-@--: :"
"@@@@----: "
"@@----::::"
"@@  --   :"
"@@  :-  : "
"@@  -:  ::"
"@@      ::"
"@@      : "
"          "
"          "
"@@@-@--:: "
"@@@@----::"
"@@--@-::  "
"    -@    "
"    @-    "
"@@@@----::"
"@@@-@--:: "
"@@@@----::"
"          "
"          "
"@@@-@--:: "
"@@@@----::"
"@@--@@::  "
"@@  --    "
"@@  -@:   "
"@@@@@---::"
"@@@-- -:: "
" @@@   -::"
"          "
"          "
"          "
"          "
"          "
" @---   ::"
"@@@@--  ::"
"@@@-@-  : "
"@@  @@  ::"
"@@  -- -  "
"@@  ---:::"
"@@   -:-: "
"      -   "
"          "
"          "
"@@@-@--:  "
"@@@@----::"
"@@--@@::: "
"@@  @-    "
"@@  --    "
"@@@@@-    "
"@@@--     "
" @@@      "
"          "
"          "
" @@-@--:: "
"@@@@----::"
"@@--@-::  "
"@@  -@    "
"@@  @-    "
"@@@@----::"
"@@@-@--:: "
" @@@----::"
"          "
"          "
" @---   ::"
"@@@@--  ::"
"@@@-@-  : "
"@@  @@  ::"
"@@  -- -  "
"@@  ---:::"
"@@   -:-: "
"      -   "
"          "
"          "
" @---   ::"
"@@@@--  ::"
"@@@-@-  : "
"@@  @@  ::"
"@@  -- -  "
"@@  ---:::"
"@@   -:-: "
"      -   "
"          "
"          "
"@@@-@- : :"
"@@@@-- -::"
"@@- @- :: "
"          "
"          "
"          "
"          "
"          "
"          "
"          "
"          ";


const char slide1[] PROGMEM = 
"                                                                                " // 0
" ##   ##   ####    ###                                                          " // 1
" ##   ##  ##  ##  ## ##        by                                               " // 2
" ##   ## ##      ##   ##         Jan Roesler           jan.roesler@tu-bs.de     " // 3
" ##   ## ##      #######         & Sebastian Br\x81" "ckner  se.brueckner@tu-bs.de    " // 4
" ##   ## ##  ### ##   ##                                                        " // 5
"  ## ##   ##  ## ##   ##       V0.000000002                                     " // 6
"   ###     ### # ##   ##                                                        " // 7
"                                                                                " // 8
"                  ######                            ##                    ###   " // 9
"                  ######                                                   ##   " // 10
"                  # ## #  #####  ## ###  ### ##    ###   ## ###   ####     ##   " // 11
"                    ##   ##   ##  ### ## #######    ##    ##  ##     ##    ##   " // 12
"                    ##   #######  ##     ## # ##    ##    ##  ##  #####    ##   " // 13
"                    ##   ##       ##     ## # ##    ##    ##  ## ##  ##    ##   " // 14
"                   ####   #####  ####    ## # ##   ####   ##  ##  ### ##  ####  " // 15
"                                                                                " // 16
"                           +-----+                                              " // 17
"                           |  M  |                                              " // 18
"                           |  A  |                          +--------------+    " // 19
"         RS-232 <--- 2 -->-+  X  +-----+                    |  20/25 Mhz   |    " // 20
"                           |  2  |     |                    |  Oszillator  |    " // 21
"                           |  3  |     |                    +-------+------+    " // 22
"                           |  2  |     2                            |           " // 23
"                           +-----+     |                            1           " // 24
"                                       |                            |           " // 25
"                                       |                            |           " // 26
"                           ++==========+=======================++   |           " // 27
"                           ||                                  ||   |           " // 28
"                           ||                                  ||   |           " // 29
"         PS/2 ------ 2 -->-++            ATmega644P            |<---+           " // 30
"                           ||                                  ||   |           " // 31
"                           ||                                  ||   |           " // 32
"                           ++=========+==========++++==========++   |           " // 33
"                                      |          ||||               |           " // 34
"                                      2          |||| 8 Bit         |           " // 35
"                                      |          ||||               |           " // 35
"                           +-------+  |       +--++++-+             |           " // 36
"                           |   7   |  |       |   7   |             |           " // 37
"                           |   4   |  |       |   4   |             |           " // 38
"                           |   H   |  |       |   H   |             |           " // 39
"         VGA <------ 5 ----+   C   +--+- 1 -<-+   C   <-------------+           " // 40
"                           |   2   |          |   1   |                         " // 41
"                           |   4   |          |   6   |                         " // 42
"                           |   4   |          |   5   |                         " // 43
"                           +-------+          +-------+                         " // 44
"                           Bustreiber         Schieberegister                   " // 45
"                                                                                "; // 47

const char slide2[] PROGMEM = 
"                                                                                "
" ######    ####       ##  #####                                                 "
"  ##  ##  ##  ##     ##  ##   ##                                                "
"  ##  ##   ##       ##        ##                                                "
"  #####     ##     ##       ###    - Tastatur                                   "
"  ##         ##   ##       ##                                                   "
"  ##      ##  ## ##       ##  ##                                                "
" ####      ####  #       #######                                                "
"                                                                                "
"                                                                                "
" PS/2: SYNCHRONES serielles Protokoll                                           "
"                                                                                "
" 2 Leitungen: Daten (bidirektional) und Takt (immer von Tastatur erzeugt)       "
"                                                                                "
"                                                                                "
" Die Daten werden von Tastatur oder PC auf der steigenden Taktflanke gesetzt    "
"                                                                                "
" und auf der fallenden Flanke gelesen                                           "
"                                                                                "
"                                                                                "
"              _________      ____      ____      ____      ____      ____       "
"   Takt                |____|    |____|    |____|    |____|    |____|    |____  "
"                                                                                "
"              ______           _________           ____________________         "
"   Daten            |_________|         |_________|                    |_______ "
"                                                                                "
"                       ^         ^         ^         ^         ^         ^      "
"                       |         |         |         |         |         |      "
"                                                                                "
"                       0         1         0         1         1         0  ... "
"                                                                                "
"                                                                                "
"    1. Taste \"A\" gedrckt          => Tastatur sendet 0x1C      sog. Make-Code  "
"                                                                                "
"    2. Taste \"A\" losgelassen       => Tastatur sendet 0xF0 1C   sog. Break-Code "
"                                                                                "
"    3. Taste \"5\" gedrckt          => Tastatur sendet 0x2E                      "
"                                                                                "
"    4. Taste \"5\" losgelassen       => Tastatur sendet 0xF0 2E                   "
"                                                                                "
"    5. Rechte Pfeiltaste gedrckt    => Tastatur sendet 0xE0 74                 "
"                                                                                "
"    6. Rechte Pfeiltaste losgelassen => Tastatur sendet 0xE0 F0 74              "
"                                                                                ";

const char slide3[] PROGMEM = 
"                                                                                "
" ##   ##   ####    ###                      VSYNC: vertikale                    " // 1
" ##   ##  ##  ##  ## ##                            (Bild-)Synchronisation       " // 2
" ##   ## ##      ##   ##                                                        " // 3
" ##   ## ##      #######  - Bildaufbau:     HSYNC: horizontale                  " // 4
" ##   ## ##  ### ##   ##                           (Zeilen-)Synchronisation     " // 5
"  ## ##   ##  ## ##   ##                                                        " // 6
"   ###     ### # ##   ##                                                        " // 7
"                                                                  VSYNC         "
"                                                                                "
"                                                                    |           "
"                                                                    |__         "
"                                                                       |        "
"                  ____      ______________________________________     |        "
"           HSYNC      |____|                                           |        "
" schwarz <                                                             |        "
"           R,G,B  ________________________________________________     |        "
"                                                                     __| BILD 1 "
"                                                                    |           "
"                  ____      ______________________________________  |           "
"           HSYNC      |____|                                        |           "
" Zeile 1 <                                                          |           "
"           R,G,B  _____________|||||||||||||||||||||||||||||||||__  |           "
"                                                                    |           "
"                                                                    |           "
"                  ____      ______________________________________  |           "
"           HSYNC      |____|                                        |           "
" Zeile 2 <                                                          |           "
"           R,G,B  _____________|||||||||||||||||||||||||||||||||__  |           "
"                                                                    |           "
"                                                                    |           "
"   ...                                                             ===          "
"                                                                    |           "
"                                                                    |__         "
"                                                                       |        "
"                  ____      ______________________________________     |        "
"           HSYNC      |____|                                           |        "
" schwarz <                                                             |        "
"           R,G,B  ________________________________________________     |        "
"                                                                     __| BILD 2 "
"                                                                    |           "
"                  ____      ______________________________________  |           "
"           HSYNC      |____|                                        |           "
" Zeile 1 <                                                          |           "
"           R,G,B  _____________|||||||||||||||||||||||||||||||||__  |           "
"                                                                    |           "
"   ...                                                              |           ";

const char slide4[] PROGMEM = 
"                                                                                "
" ##   ##   ####    ###       Das Timing der VGA-Signale (VSYNC, HSYNC, R, G, B) " // 1
" ##   ##  ##  ##  ## ##                                                         " // 2
" ##   ## ##      ##   ##     ist von der VESA (Video Electronics Standards      " // 3
" ##   ## ##      #######                                                        " // 4
" ##   ## ##  ### ##   ##     Association) festgelegt.                           " // 5
"  ## ##   ##  ## ##   ##                                                        " // 6
"   ###     ### # ##   ##                                                        " // 7
"                                                                                "
"                                                                                "
"                                                                                "
"   Aufbau einer Video-ZEILE:                                                    "
"                                                                                "
"              ____      _______________________________________________________ "
"   HSYNC          |____|                                                        "
"                                                                                "
"                              _   _   _   _   _   _   _   _   _   _   _   _     "
"   R,G,B      _______________| |_| |_| |_| |_| |_| |_| |_| |_| |_| |_| |_| |___ "
"                                                                                "
"                                                                                "
"              <-->                   vordere Schwarzschulter (front porch)      "
"                                                                                "
"                  <---->             Synchronisations-Puls (hor. sync)          "
"                                                                                "
"                        <--->        hintere Schwarzschulter (back porch)       "
"                                                                                "
"                             <----   sichtbarer Bereich (active video)  ------> "
"                                                                                "
"                                                                                "
"                                                                                "
"                                                                                "
"   Aufbau eines Video-BILDs (frame):                                            "
"                                                                                "
"                     _____________                                              "
"   VSYNC       _____|             |____________________________________________ "
"                                                                                "
"               _   ____   ____   ____   ____   ____   ____   ____   ____   ____ "
"   HSYNC        |_|    |_|    |_|    |_|    |_|    |_|    |_|    |_|    |_|     "
"                                                                                "
"                    __     __     __     __     __     __     __     __     __  "
"   R,G,B      _____|  |___|  |___|  |___|  |___|  |___|  |___|  |___|  |___|  | "
"                                                                                ";

PGM_P const slides[SLIDES_TOTAL] PROGMEM = {
    slide1,
    slide2,
	slide3,
	slide4
};
