//
// vt100.c
//
// This file contains a very basic implementation of the VT100 command set.
// Only a small subset of commands is supported, based on what seemed useful
// in this device i.e. all color and font-style operations are silently
// ignored.
// For reference see http://www.termsys.demon.co.uk/vtansi.htm
//
// (c) 2009 by Sebastian Brueckner <sb@thebackend.de>
//

#include <avr/io.h>
#include <stdint.h>
#include "global.h"
#include "framebuffer.h"
#include "vt100.h"

// VT100 STATES
#define VS_CHARACTER 0
#define VS_ESCAPE    1

static uint8_t vt_state = VS_CHARACTER;

static inline void vt100_putchar(uint8_t c)
{
	fb_putchar(c);
	cursor_advance();
}

void vt100_handle_input(uint8_t c)
{
	switch(vt_state)
	{
	case VS_CHARACTER:
		if(c == 27) vt_state = VS_ESCAPE;
		else if(c == '\n') cursor_newline();
		else if(c == '\r') nop();
		else vt100_putchar(c);
		break;
	case VS_ESCAPE:
		break;
	default:
		vt_state = VS_CHARACTER;
		vt100_putchar(c);
	}
}
