#if !defined(FRAMEBUFFER_H_)
#define FRAMEBUFFER_H_

#include <avr/pgmspace.h>
#include <stdint.h>
#include "global.h"

#define FB_CENTERED 255

void cursor_advance();
void cursor_newline();
void cursor_set(uint8_t x, uint8_t y);
void cursor_push(uint8_t x, uint8_t y);
void cursor_pop();
void fb_putchar(uint8_t c);
uint8_t fb_getchar();
//void fb_putchar_xy( uint8_t x, uint8_t y, uint8_t c);
void fb_putstr_P(PGM_P str);
void fb_putstr_xy_P(uint8_t x, uint8_t y, PGM_P str);
void fb_clear();

void cursor_blink();


static inline void __attribute__ ((always_inline)) fb_putchar_xy( uint8_t x, uint8_t y, uint8_t c)
{
	framebuf[y * H_CHARS + x] = c;
}

static inline uint8_t __attribute__ ((always_inline)) fb_getchar_xy( uint8_t x, uint8_t y)
{
	return framebuf[y * H_CHARS + x];
}


#endif // FRAMEBUFFER_H_
